import { Router } from 'express';
import { kycController } from './controller';
import { authenticateUser, requireVendor, requireAdmin } from '@/middlewares/auth';
import { vendorService } from '@/modules/vendors/service';

const router = Router();

// Attach vendor to req for downstream use
async function attachVendor(req: any, res: any, next: any) {
  if (req.user) {
    const { data: vendor } = await vendorService.getVendorByUserId(req.user.id);
    req.vendor = vendor || null;
  }
  next();
}

// Attach admin to req for downstream use (simulate admin extraction)
async function attachAdmin(req: any, res: any, next: any) {
  // In real app, extract admin from session or JWT
  req.admin = req.user; // Assume admin is authenticated user for now
  next();
}

// Vendor KYC endpoints
router.post('/submit', authenticateUser, requireVendor, attachVendor, kycController.submit);
router.get('/status', authenticateUser, requireVendor, attachVendor, kycController.status);

// Admin KYC endpoints
router.get('/admin/pending', authenticateUser, requireAdmin, attachAdmin, kycController.adminListPending);
router.post('/admin/:vendorId/review', authenticateUser, requireAdmin, attachAdmin, kycController.adminReview);

export default router; 